<?php 
namespace ZS\Usaepay\Controller\Customer;  

use Magento\Framework\App\RequestInterface;

class Delete extends \Magento\Framework\App\Action\Action { 
  
  	protected $_customerSession;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Session $customerSession
    ) {
        parent::__construct($context);
        $this->_customerSession = $customerSession;
    }

    public function dispatch(RequestInterface $request)
    {
        if (!$this->_customerSession->authenticate()) {
            $this->_actionFlag->set('', 'no-dispatch', true);
        }
        return parent::dispatch($request);
    }


	public function execute() {
	  	$id = $this->getRequest()->getParam('id');
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($id) {
            try {
                $model = $this->_objectManager->get('\ZS\Usaepay\Model\CardFactory')->create()->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('Payment Method has been deleted successfully.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            }
        }
        $this->messageManager->addError(__('Card does not exist'));
        return $resultRedirect->setPath('usaepay/customer/index');
	    
	} 
  
} 